/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.gui;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.IItemDecorator;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterItemDecorationsEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.ElementStorageHelper;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.block.anchor.TranslocationAnchorList;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.ShrineElementStorage;
import sirttas.elementalcraft.block.shrine.upgrade.translocation.TranslocationShrineUpgradeBlockItem;
import sirttas.elementalcraft.client.LevelRenderHandler;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.gui.GuiHelper;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.spell.ISpellHolder;
import sirttas.elementalcraft.jewel.Jewel;
import sirttas.elementalcraft.jewel.handler.IJewelHandler;
import sirttas.elementalcraft.renderer.ECRendererHelper;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;
import sirttas.elementalcraft.spell.Spells;
import sirttas.elementalcraft.spell.air.TranslocationSpell;
import sirttas.elementalcraft.spell.tick.SpellCooldownItemDecorator;
import sirttas.elementalcraft.spell.tick.SpellTickHelper;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="elementalcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class GuiHandler {
    public static final Material TRANSLOCATION_ANCHOR_MARKER = ECRendererHelper.getBlockMaterial("gui/translocation_anchor_marker");

    private GuiHandler() {
    }

    @SubscribeEvent
    public static void registerItemDecorators(RegisterItemDecorationsEvent event) {
        SpellCooldownItemDecorator spellCooldown = new SpellCooldownItemDecorator();
        event.register((ItemLike)ECItems.SCROLL.get(), (IItemDecorator)spellCooldown);
        event.register((ItemLike)ECItems.FOCUS.get(), (IItemDecorator)spellCooldown);
        event.register((ItemLike)ECItems.STAFF.get(), (IItemDecorator)spellCooldown);
    }

    @SubscribeEvent
    public static void onDrawScreenPost(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.CROSSHAIR.id(), "gauge", (f, g, t, w, h) -> GuiHandler.drawGauge(f, g));
        event.registerBelow(VanillaGuiOverlay.PORTAL.id(), "translocation_anchor_marker", (f, g, t, w, h) -> GuiHandler.drawAnchors(f, g, w, h));
        event.registerBelow(ElementalCraft.createRL("translocation_anchor_marker"), "single_translocation_anchor_marker", (f, g, t, w, h) -> GuiHandler.drawAnchor(f, g, w, h));
    }

    public static void drawGauge(ForgeGui gui, GuiGraphics guiGraphics) {
        Font font = gui.m_93082_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        gui.setupOverlayRenderState(true, false);
        Spell spell = GuiHandler.getSpell();
        int i = 0;
        for (ISingleElementStorage storage : GuiHandler.getElementStorage((Player)player)) {
            ElementType type = storage.getElementType();
            GuiHandler.renderElementGauge(guiGraphics, font, storage.getElementAmount(), storage.getElementCapacity(), type, i);
            gui.setupOverlayRenderState(true, false);
            if (storage instanceof ShrineElementStorage) {
                ShrineElementStorage shrineStorage = (ShrineElementStorage)storage;
                GuiHandler.renderShrineCheck(guiGraphics, storage, shrineStorage);
            } else if (spell.isValid() && spell.getElementType() == type && i == 0 && GuiHandler.isPlayerOwned((Player)player, storage)) {
                GuiHandler.renderSpellCheck(guiGraphics, player, spell);
            }
            ++i;
        }
    }

    private static boolean isPlayerOwned(Player player, ISingleElementStorage storage) {
        return ElementStorageHelper.get((ICapabilityProvider)player).map(s -> s.forElement(storage.getElementType())).map(s -> s.getElementAmount() == storage.getElementAmount() && s.getElementCapacity() == storage.getElementCapacity()).orElse(false);
    }

    public static void drawAnchors(ForgeGui gui, GuiGraphics guiGraphics, int width, int height) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Matrix4f worldMatrix = LevelRenderHandler.getWorldMatrix();
        if (worldMatrix == null || player == null || !TranslocationSpell.holdsTranslocation((Player)player) || TranslocationAnchorList.CLIENT_LIST.isEmpty()) {
            return;
        }
        BlockPos targetAnchor = TranslocationSpell.getTargetAnchor((Entity)player, TranslocationAnchorList.CLIENT_LIST);
        float range = ((TranslocationSpell)Spells.TRANSLOCATION.get()).getRange((Entity)player);
        float rangeSq = range * range;
        float falloffSq = range / 2.0f * (range / 2.0f);
        Vec3 cameraPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        Vec3 playerPos = player.m_20182_();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        gui.setupOverlayRenderState(true, false);
        for (BlockPos anchor : TranslocationAnchorList.CLIENT_LIST) {
            Vector4f v;
            Vec3 center = Vec3.m_82512_((Vec3i)anchor);
            double distanceSq = center.m_82557_(playerPos);
            if (!(distanceSq <= (double)rangeSq) || (v = GuiHandler.getPositionInScreen(worldMatrix, cameraPos, center)).z() <= 0.0f || v.z() >= 1.0f) continue;
            GuiHandler.drawAnchor(guiGraphics.m_280168_(), width, height, anchor.equals((Object)targetAnchor) ? 1.5f : GuiHandler.getAnchorScale(falloffSq, (float)distanceSq), buffer, v);
        }
        buffer.m_109911_();
    }

    public static void drawAnchor(ForgeGui gui, GuiGraphics guiGraphics, int width, int height) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Matrix4f worldMatrix = LevelRenderHandler.getWorldMatrix();
        if (worldMatrix == null || player == null || TranslocationAnchorList.CLIENT_LIST.isEmpty()) {
            return;
        }
        BlockPos anchor = TranslocationShrineUpgradeBlockItem.getTargetAnchor((Player)player);
        if (anchor == null || !TranslocationAnchorList.CLIENT_LIST.contains(anchor)) {
            return;
        }
        float range = ((TranslocationSpell)Spells.TRANSLOCATION.get()).getRange(null);
        float rangeSq = range * range;
        Vec3 center = Vec3.m_82512_((Vec3i)anchor);
        double distanceSq = center.m_82557_(player.m_20182_());
        if (distanceSq > (double)rangeSq) {
            return;
        }
        Vector4f v = GuiHandler.getPositionInScreen(worldMatrix, Minecraft.m_91087_().f_91063_.m_109153_().m_90583_(), center);
        if (v.z() <= 0.0f || v.z() >= 1.0f) {
            return;
        }
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        gui.setupOverlayRenderState(true, false);
        GuiHandler.drawAnchor(guiGraphics.m_280168_(), width, height, 1.5f, buffer, v);
        buffer.m_109911_();
    }

    private static void drawAnchor(PoseStack poseStack, int width, int height, float scale, MultiBufferSource.BufferSource buffer, Vector4f v) {
        float w = (float)width / 2.0f;
        float h = (float)height / 2.0f;
        float x = Mth.m_14036_((float)(w + v.x() * w), (float)16.0f, (float)((float)width - 16.0f));
        float y = Mth.m_14036_((float)(h - v.y() * h), (float)16.0f, (float)((float)height - 16.0f));
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, 1.0f);
        poseStack.m_85841_(0.25f, 0.25f, 1.0f);
        poseStack.m_85841_(scale, scale, 1.0f);
        poseStack.m_252880_(-64.0f, -64.0f, 1.0f);
        ECRendererHelper.renderIcon(poseStack, (MultiBufferSource)buffer, TRANSLOCATION_ANCHOR_MARKER, 128, 128);
        poseStack.m_85849_();
    }

    private static float getAnchorScale(float falloffSq, float distanceSq) {
        return Mth.m_14036_((float)(1.0f - distanceSq / falloffSq), (float)0.2f, (float)1.0f);
    }

    @Nonnull
    private static Vector4f getPositionInScreen(Matrix4f worldMatrix, Vec3 cameraPos, Vec3 center) {
        Vector4f v = new Vector4f((float)(center.f_82479_ - cameraPos.f_82479_), (float)(center.f_82480_ - cameraPos.f_82480_), (float)(center.f_82481_ - cameraPos.f_82481_), 1.0f);
        worldMatrix.transform(v);
        v.div((Vector4fc)v);
        return v;
    }

    private static List<ISingleElementStorage> getElementStorage(Player player) {
        Optional holder;
        Minecraft minecraft = Minecraft.m_91087_();
        HitResult result = minecraft.f_91077_;
        if (result != null && minecraft.f_91066_.m_92176_().m_90612_()) {
            List<ISingleElementStorage> storages;
            BlockEntity tile;
            BlockPos pos = result.m_6662_() == HitResult.Type.BLOCK ? ((BlockHitResult)result).m_82425_() : null;
            BlockEntity blockEntity = tile = pos != null ? minecraft.f_91074_.m_9236_().m_7702_(pos) : null;
            if (tile != null && !(storages = ElementStorageHelper.get((ICapabilityProvider)tile).filter(storage -> storage.doesRenderGauge() || GuiHelper.showDebugInfo()).map(GuiHandler::splitStorage).orElse(Collections.emptyList())).isEmpty()) {
                return storages;
            }
        }
        if ((holder = EntityHelper.handStream(player).map(stack -> ElementStorageHelper.get((ICapabilityProvider)stack).resolve()).mapMulti(Optional::ifPresent).findFirst()).isPresent()) {
            return GuiHandler.splitStorage((IElementStorage)holder.get());
        }
        Optional playerStorage = ElementStorageHelper.get((ICapabilityProvider)player).resolve();
        if (playerStorage.isEmpty()) {
            return Collections.emptyList();
        }
        ElementType spellElementType = EntityHelper.handStream(player).map(stack -> {
            if (!stack.m_41619_() && stack.m_41720_() instanceof ISpellHolder) {
                return SpellHelper.getSpell(stack).getElementType();
            }
            return ElementType.NONE;
        }).filter(type -> type != ElementType.NONE).findFirst().orElse(ElementType.NONE);
        ArrayList<ElementType> list = new ArrayList<ElementType>(4);
        if (spellElementType != ElementType.NONE) {
            list.add(spellElementType);
        }
        player.getCapability(IJewelHandler.CAPABILITY).ifPresent(handler -> handler.getActiveJewels().stream().map(Jewel::getElementType).distinct().filter(type -> type != ElementType.NONE && type != spellElementType).forEach(list::add));
        return GuiHandler.splitStorage((IElementStorage)playerStorage.get(), list);
    }

    private static List<ISingleElementStorage> splitStorage(IElementStorage storage) {
        if (storage instanceof ISingleElementStorage) {
            ISingleElementStorage singleElementStorage = (ISingleElementStorage)storage;
            return Collections.singletonList(singleElementStorage);
        }
        return GuiHandler.splitStorage(storage, ElementType.ALL_VALID);
    }

    private static List<ISingleElementStorage> splitStorage(IElementStorage storage, List<ElementType> elementTypes) {
        if (storage instanceof ISingleElementStorage) {
            ISingleElementStorage singleElementStorage = (ISingleElementStorage)storage;
            return elementTypes.contains(singleElementStorage.getElementType()) ? List.of(singleElementStorage) : Collections.emptyList();
        }
        return elementTypes.stream().mapMulti((type, downstream) -> downstream.accept(storage.forElement((ElementType)type))).filter(s -> s.getElementCapacity() > 0).toList();
    }

    private static Spell getSpell() {
        return EntityHelper.handStream((Player)Minecraft.m_91087_().f_91074_).map(stack -> {
            if (!stack.m_41619_() && stack.m_41720_() instanceof ISpellHolder) {
                return SpellHelper.getSpell(stack);
            }
            return (Spell)Spells.NONE.get();
        }).filter(Spell::isValid).findFirst().orElseGet((Supplier<Spell>)Spells.NONE);
    }

    private static void renderElementGauge(GuiGraphics guiGraphics, Font font, int element, int max, ElementType type, int index) {
        GuiHelper.renderElementGauge(guiGraphics, font, GuiHandler.getXOffset() - 32 - 20 * index, GuiHandler.getYOffset() - 8, element, max, type);
    }

    public static int getYOffset() {
        return Minecraft.m_91087_().m_91268_().m_85446_() / 2 + (Integer)ECConfig.CLIENT.gaugeOffsetX.get();
    }

    public static int getXOffset() {
        return Minecraft.m_91087_().m_91268_().m_85445_() / 2 + (Integer)ECConfig.CLIENT.gaugeOffsetY.get();
    }

    private static void renderShrineCheck(GuiGraphics guiGraphics, ISingleElementStorage storage, ShrineElementStorage shrineStorage) {
        AbstractShrineBlockEntity shrine = shrineStorage.getShrine();
        if (shrine.isRunning()) {
            GuiHandler.renderCheck(guiGraphics, GuiHelper.Check.VALID);
        } else if (storage.getElementAmount() >= shrine.getConsumeAmount()) {
            GuiHandler.renderCheck(guiGraphics, GuiHelper.Check.PAUSED);
        } else {
            GuiHandler.renderCheck(guiGraphics, GuiHelper.Check.INVALID);
        }
    }

    private static void renderSpellCheck(GuiGraphics guiGraphics, LocalPlayer player, Spell spell) {
        boolean canCast = spell.consume((Entity)player, true);
        boolean isInCooldown = SpellTickHelper.hasCooldown((ICapabilityProvider)player, spell);
        if (canCast && !isInCooldown) {
            GuiHandler.renderCheck(guiGraphics, GuiHelper.Check.VALID);
        } else if (isInCooldown) {
            GuiHandler.renderCheck(guiGraphics, GuiHelper.Check.PAUSED);
        } else {
            GuiHandler.renderCheck(guiGraphics, GuiHelper.Check.INVALID);
        }
    }

    private static void renderCheck(GuiGraphics guiGraphics, GuiHelper.Check valid) {
        GuiHelper.renderCheck(guiGraphics, valid, GuiHandler.getXOffset() - 21, GuiHandler.getYOffset() + 3);
    }
}

