/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source.trait.holder;

import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.util.INBTSerializable;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.source.trait.SourceTrait;
import sirttas.elementalcraft.api.source.trait.holder.ISourceTraitHolder;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.block.source.trait.SourceTraitHelper;
import sirttas.elementalcraft.block.source.trait.SourceTraits;

public class SourceTraitHolder
implements ISourceTraitHolder,
INBTSerializable<CompoundTag> {
    private final Map<ResourceKey<SourceTrait>, ISourceTraitValue> traits = SourceTraits.createTraitMap();

    @Override
    public Map<ResourceKey<SourceTrait>, ISourceTraitValue> getTraits() {
        return this.traits;
    }

    @Override
    public void setTraits(Map<ResourceKey<SourceTrait>, ISourceTraitValue> traits) {
        this.traits.clear();
        this.traits.putAll(traits);
    }

    @Override
    public boolean isArtificial() {
        return this.traits.containsKey(SourceTraits.ARTIFICIAL);
    }

    public void initTraits(ServerLevelAccessor level, BlockPos pos, int luck) {
        if (this.traits.isEmpty()) {
            for (Map.Entry entry : ElementalCraftApi.SOURCE_TRAIT_MANAGER.getData().entrySet()) {
                ISourceTraitValue value;
                ResourceKey<SourceTrait> key = SourceTraits.key((ResourceLocation)entry.getKey());
                if (key.equals(SourceTraits.ARTIFICIAL) || (value = ((SourceTrait)entry.getValue()).roll(level, pos, luck)) == null) continue;
                this.traits.put(key, value);
            }
        }
    }

    public void clear() {
        this.traits.clear();
    }

    public void deserializeNBT(@Nonnull CompoundTag compound) {
        SourceTraitHelper.loadTraits(compound, this.traits);
    }

    public CompoundTag serializeNBT() {
        return SourceTraitHelper.saveTraits(this.traits);
    }
}

