/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source.trait;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sirttas.dpanvil.api.data.IDataManager;
import sirttas.dpanvil.api.event.DataManagerReloadEvent;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.source.trait.SourceTrait;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;

@Mod.EventBusSubscriber(modid="elementalcraft")
public class SourceTraits {
    private static final Map<ResourceKey<SourceTrait>, Integer> SOURCE_TRAITS_ORDERS = new HashMap<ResourceKey<SourceTrait>, Integer>();
    public static final ResourceKey<SourceTrait> ELEMENT_CAPACITY = SourceTraits.key("element_capacity");
    public static final ResourceKey<SourceTrait> RECOVER_RATE = SourceTraits.key("recover_rate");
    public static final ResourceKey<SourceTrait> DIURNAL_NOCTURNAL = SourceTraits.key("diurnal_nocturnal");
    public static final ResourceKey<SourceTrait> GENEROSITY = SourceTraits.key("generosity");
    public static final ResourceKey<SourceTrait> THRIFTINESS = SourceTraits.key("thriftiness");
    public static final ResourceKey<SourceTrait> FERTILITY = SourceTraits.key("fertility");
    public static final ResourceKey<SourceTrait> ARTIFICIAL = SourceTraits.key("artificial");

    private SourceTraits() {
    }

    @Nonnull
    public static SortedMap<ResourceKey<SourceTrait>, ISourceTraitValue> createTraitMap() {
        return new TreeMap<ResourceKey<SourceTrait>, ISourceTraitValue>(Comparator.comparingInt(SourceTraits::getOrder));
    }

    public static int getOrder(ResourceKey<SourceTrait> trait) {
        return SOURCE_TRAITS_ORDERS.getOrDefault(trait, Integer.MAX_VALUE);
    }

    public static ResourceKey<SourceTrait> key(String name) {
        return SourceTraits.key(ElementalCraft.createRL(name));
    }

    public static ResourceKey<SourceTrait> key(ResourceLocation name) {
        return IDataManager.createKey(ElementalCraftApi.SOURCE_TRAIT_MANAGER_KEY, (ResourceLocation)name);
    }

    @SubscribeEvent
    public static void onSourceTraitReloaded(DataManagerReloadEvent<SourceTrait> event) {
        SOURCE_TRAITS_ORDERS.clear();
        event.getDataManager().getData().forEach((key, trait) -> SOURCE_TRAITS_ORDERS.put((ResourceKey<SourceTrait>)IDataManager.createKey(ElementalCraftApi.SOURCE_TRAIT_MANAGER_KEY, (ResourceLocation)key), trait.getOrder()));
    }
}

