/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.harvest;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.properties.ShrineProperties;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.block.shrine.upgrade.vertical.PlantingShrineUpgradeBlock;
import sirttas.elementalcraft.loot.LootHelper;
import sirttas.elementalcraft.tag.ECTags;

public class HarvestShrineBlockEntity
extends AbstractShrineBlockEntity {
    public static final ResourceKey<ShrineProperties> PROPERTIES_KEY = HarvestShrineBlockEntity.createKey("harvestshrine");
    protected static final List<Direction> UPGRADE_DIRECTIONS = List.of(Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);

    public HarvestShrineBlockEntity(BlockPos pos, BlockState state) {
        super(ECBlockEntityTypes.HARVEST_SHRINE, pos, state, PROPERTIES_KEY);
    }

    private Optional<BlockPos> findCrop() {
        return this.getBlocksInRange().filter(this::canHarvest).findAny();
    }

    private boolean canHarvest(BlockPos pos) {
        CropBlock cropBlock;
        BlockState state = this.f_58857_.m_8055_(pos);
        Block block = state.m_60734_();
        return block instanceof CropBlock && (cropBlock = (CropBlock)block).m_52307_(state) || state.m_204336_(ECTags.Blocks.SHRINES_HARVEST_HARVESTABLE_TALL_PLANTS) && this.f_58857_.m_8055_(pos.m_7495_()).m_204336_(ECTags.Blocks.SHRINES_HARVEST_HARVESTABLE_TALL_PLANTS);
    }

    private void handlePlanting(BlockPos pos, ItemLike provider, List<ItemStack> loots) {
        Item item;
        if (!this.hasUpgrade(ShrineUpgrades.PLANTING) || !((item = provider.m_5456_()) instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        loots.stream().filter(stack -> stack.m_41720_().equals(blockItem)).findFirst().ifPresent(seeds -> {
            if (PlantingShrineUpgradeBlock.plant(seeds, this.f_58857_, pos)) {
                seeds.m_41774_(1);
                if (seeds.m_41619_()) {
                    loots.remove(seeds);
                }
            }
        });
    }

    @Override
    protected boolean doPeriod() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.f_58857_.f_46443_) {
                return this.findCrop().map(p -> {
                    List<ItemStack> loots = LootHelper.getDrops(serverLevel, p);
                    Block block = this.f_58857_.m_8055_(p).m_60734_();
                    this.f_58857_.m_46961_(p, false);
                    this.handlePlanting((BlockPos)p, (ItemLike)block, loots);
                    loots.forEach(stack -> Block.m_49840_((Level)this.f_58857_, (BlockPos)p, (ItemStack)stack));
                    return true;
                }).orElse(false);
            }
        }
        return false;
    }

    @Override
    public List<Direction> getUpgradeDirections() {
        return UPGRADE_DIRECTIONS;
    }
}

