/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.breeding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.breeding.BreedingShrineBlock;
import sirttas.elementalcraft.block.shrine.properties.ShrineProperties;

public class BreedingShrineBlockEntity
extends AbstractShrineBlockEntity {
    public static final ResourceKey<ShrineProperties> PROPERTIES_KEY = BreedingShrineBlockEntity.createKey("breedingshrine");

    public BreedingShrineBlockEntity(BlockPos pos, BlockState state) {
        super(ECBlockEntityTypes.BREEDING_SHRINE, pos, state, PROPERTIES_KEY);
    }

    private <T extends Entity> List<T> getEntities(Class<T> clazz) {
        return new ArrayList(this.m_58904_().m_6443_(clazz, this.getRange(), e -> !e.m_5833_()));
    }

    @Override
    public AABB getRange() {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BreedingShrineBlock.FACING);
        AABB box = super.getRange();
        return box.m_82386_((double)facing.m_122429_() * (box.m_82362_() - 1.0) * 0.5, 0.0, (double)facing.m_122431_() * (box.m_82385_() - 1.0) * 0.5);
    }

    @Override
    protected boolean doPeriod() {
        EntityType type = null;
        Animal first = null;
        Animal second = null;
        for (Animal entity : this.getEntities(Animal.class)) {
            if (type == null && entity.m_5957_()) {
                type = entity.m_6095_();
                first = entity;
                continue;
            }
            if (second != null || type == null || !type.equals(entity.m_6095_()) || !entity.m_5957_()) continue;
            second = entity;
        }
        if (first != null && second != null) {
            return this.feed(first, second);
        }
        return false;
    }

    public boolean consumeFood(Animal first) {
        List<ItemStack> foodList = this.getEntities(ItemEntity.class).stream().map(ItemEntity::m_32055_).filter(stack -> first.m_6898_(stack) && !stack.m_41619_()).toList();
        if (foodList.isEmpty()) {
            return false;
        }
        if (foodList.get(0).m_41613_() >= 2) {
            foodList.get(0).m_41774_(2);
        } else if (foodList.size() >= 2) {
            foodList.get(0).m_41774_(1);
            foodList.get(1).m_41774_(1);
        } else {
            return false;
        }
        return true;
    }

    public boolean feed(Animal first, Animal second) {
        if (!this.consumeFood(first)) {
            return false;
        }
        this.setInLove(first);
        this.setInLove(second);
        return true;
    }

    private void setInLove(Animal first) {
        first.m_27601_(600);
        this.f_58857_.m_7605_((Entity)first, (byte)18);
    }

    @Override
    public List<Direction> getUpgradeDirections() {
        BlockState state = this.m_58900_();
        return state.m_61143_(BreedingShrineBlock.PART) == BreedingShrineBlock.Part.BOWL ? Collections.emptyList() : DEFAULT_UPGRADE_DIRECTIONS.stream().filter(direction -> direction != state.m_61143_((Property)BreedingShrineBlock.FACING)).collect(Collectors.toList());
    }
}

