/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.container;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import sirttas.elementalcraft.block.container.AbstractElementContainerBlockEntity;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.renderer.ECRendererHelper;
import sirttas.elementalcraft.tag.ECTags;

public class ContainerRenderer<T extends AbstractElementContainerBlockEntity>
implements BlockEntityRenderer<T> {
    public void render(@Nonnull T container, float pPartialTick, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (Boolean.FALSE.equals(ECConfig.CLIENT.renderInstrumentShadow.get())) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Level level = container.m_58904_();
        if (level == null || player == null) {
            return;
        }
        BlockPos pos = container.m_58899_();
        Iterator<ItemStack> iterator = List.of(player.m_21205_(), player.m_21206_()).iterator();
        boolean wasRendered = false;
        while (iterator.hasNext() && !wasRendered) {
            BlockState state;
            ItemStack stack = iterator.next();
            Item item = stack.m_41720_();
            if (!(item instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)item;
            if (!stack.m_204117_(container.isSmall() ? ECTags.Items.SMALL_CONTAINER_COMPATIBLES : ECTags.Items.CONTAINER_TOOLS)) continue;
            Block block = blockItem.m_40614_();
            BlockPos instrumentPos = pos.m_7494_();
            if (!level.m_8055_(instrumentPos).m_60795_() || (state = block.m_5573_((BlockPlaceContext)new DirectionalPlaceContext(level, instrumentPos, Direction.DOWN, stack, Direction.UP))) == null || !state.m_60710_((LevelReader)level, instrumentPos)) continue;
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 1.0f, 0.0f);
            ECRendererHelper.renderGhost(state, poseStack, bufferSource, level, instrumentPos);
            poseStack.m_85849_();
            wasRendered = true;
        }
    }
}

