/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block;

import java.util.function.Supplier;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.anchor.TranslocationAnchorBlock;
import sirttas.elementalcraft.block.container.ElementContainerBlock;
import sirttas.elementalcraft.block.container.SmallElementContainerBlock;
import sirttas.elementalcraft.block.container.creative.CreativeElementContainerBlock;
import sirttas.elementalcraft.block.container.reservoir.ReservoirBlock;
import sirttas.elementalcraft.block.diffuser.DiffuserBlock;
import sirttas.elementalcraft.block.evaporator.EvaporatorBlock;
import sirttas.elementalcraft.block.extractor.ExtractorBlock;
import sirttas.elementalcraft.block.extractor.improved.ImprovedExtractorBlock;
import sirttas.elementalcraft.block.instrument.binder.BinderBlock;
import sirttas.elementalcraft.block.instrument.binder.improved.ImprovedBinderBlock;
import sirttas.elementalcraft.block.instrument.crystallizer.CrystallizerBlock;
import sirttas.elementalcraft.block.instrument.infuser.InfuserBlock;
import sirttas.elementalcraft.block.instrument.inscriber.InscriberBlock;
import sirttas.elementalcraft.block.instrument.io.firefurnace.FireFurnaceBlock;
import sirttas.elementalcraft.block.instrument.io.firefurnace.blast.FireBlastFurnaceBlock;
import sirttas.elementalcraft.block.instrument.io.mill.grindstone.air.AirMillGrindstoneBlock;
import sirttas.elementalcraft.block.instrument.io.mill.grindstone.water.WaterMillGrindstoneBlock;
import sirttas.elementalcraft.block.instrument.io.mill.woodsaw.air.AirMillWoodSawBlock;
import sirttas.elementalcraft.block.instrument.io.mill.woodsaw.water.WaterMillWoodSawBlock;
import sirttas.elementalcraft.block.instrument.io.purifier.PurifierBlock;
import sirttas.elementalcraft.block.pipe.ElementPipeBlock;
import sirttas.elementalcraft.block.pureinfuser.PureInfuserBlock;
import sirttas.elementalcraft.block.pureinfuser.pedestal.PedestalBlock;
import sirttas.elementalcraft.block.retriever.RetrieverBlock;
import sirttas.elementalcraft.block.shrine.breeding.BreedingShrineBlock;
import sirttas.elementalcraft.block.shrine.budding.BuddingShrineBlock;
import sirttas.elementalcraft.block.shrine.enderlock.EnderLockShrineBlock;
import sirttas.elementalcraft.block.shrine.firepylon.FirePylonBlock;
import sirttas.elementalcraft.block.shrine.grove.GroveShrineBlock;
import sirttas.elementalcraft.block.shrine.growth.GrowthShrineBlock;
import sirttas.elementalcraft.block.shrine.harvest.HarvestShrineBlock;
import sirttas.elementalcraft.block.shrine.lava.LavaShrineBlock;
import sirttas.elementalcraft.block.shrine.lumber.LumberShrineBlock;
import sirttas.elementalcraft.block.shrine.ore.OreShrineBlock;
import sirttas.elementalcraft.block.shrine.overload.OverloadShrineBlock;
import sirttas.elementalcraft.block.shrine.spawning.SpawningShrineBlock;
import sirttas.elementalcraft.block.shrine.spring.SpringShrineBlock;
import sirttas.elementalcraft.block.shrine.sweet.SweetShrineBlock;
import sirttas.elementalcraft.block.shrine.upgrade.acceleration.AccelerationShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.acceleration.overclocked.OverclockedAccelerationShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.directional.CapacityShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.directional.EfficiencyShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.directional.OptimizationShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.directional.RangeShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.directional.StrengthShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.horizontal.CrystalHarvestShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.horizontal.FortuneShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.horizontal.NectarShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.horizontal.ProtectionShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.horizontal.SilkTouchShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.horizontal.SpringalineShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.translocation.TranslocationShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.unidirectional.BonelessGrowthShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.unidirectional.CrystalGrowthShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.unidirectional.FillingShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.unidirectional.MysticalGroveShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.unidirectional.PickupShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.unidirectional.StemPollinationShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.vertical.PlantingShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.vortex.VortexShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.vacuum.VacuumShrineBlock;
import sirttas.elementalcraft.block.sorter.SorterBlock;
import sirttas.elementalcraft.block.source.SourceBlock;
import sirttas.elementalcraft.block.source.breeder.SourceBreederBlock;
import sirttas.elementalcraft.block.source.breeder.pedestal.SourceBreederPedestalBlock;
import sirttas.elementalcraft.block.source.displacement.plate.BrokenSourceDisplacementPlateBlock;
import sirttas.elementalcraft.block.source.displacement.plate.SourceDisplacementPlateBlock;
import sirttas.elementalcraft.block.spelldesk.SpellDeskBlock;
import sirttas.elementalcraft.block.synthesizer.mana.ManaSynthesizerBlock;
import sirttas.elementalcraft.block.synthesizer.solar.SolarSynthesizerBlock;
import sirttas.elementalcraft.property.ECProperties;

public class ECBlocks {
    private static final DeferredRegister<Block> DEFERRED_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"elementalcraft");
    public static final RegistryObject<SmallElementContainerBlock> SMALL_CONTAINER = ECBlocks.register("small_container", SmallElementContainerBlock::new);
    public static final RegistryObject<ElementContainerBlock> CONTAINER = ECBlocks.register("container", ElementContainerBlock::new);
    public static final RegistryObject<ReservoirBlock> FIRE_RESERVOIR = ECBlocks.register("reservoir_fire", () -> new ReservoirBlock(ElementType.FIRE));
    public static final RegistryObject<ReservoirBlock> WATER_RESERVOIR = ECBlocks.register("reservoir_water", () -> new ReservoirBlock(ElementType.WATER));
    public static final RegistryObject<ReservoirBlock> EARTH_RESERVOIR = ECBlocks.register("reservoir_earth", () -> new ReservoirBlock(ElementType.EARTH));
    public static final RegistryObject<ReservoirBlock> AIR_RESERVOIR = ECBlocks.register("reservoir_air", () -> new ReservoirBlock(ElementType.AIR));
    public static final RegistryObject<CreativeElementContainerBlock> CREATIVE_CONTAINER = ECBlocks.register("creative_container", CreativeElementContainerBlock::new);
    public static final RegistryObject<ExtractorBlock> EXTRACTOR = ECBlocks.register("extractor", ExtractorBlock::new);
    public static final RegistryObject<ImprovedExtractorBlock> EXTRACTOR_IMPROVED = ECBlocks.register("extractor_improved", ImprovedExtractorBlock::new);
    public static final RegistryObject<EvaporatorBlock> EVAPORATOR = ECBlocks.register("evaporator", EvaporatorBlock::new);
    public static final RegistryObject<SolarSynthesizerBlock> SOLAR_SYNTHESIZER = ECBlocks.register("solar_synthesizer", SolarSynthesizerBlock::new);
    public static final RegistryObject<ManaSynthesizerBlock> MANA_SYNTHESIZER = ECBlocks.register("mana_synthesizer", ManaSynthesizerBlock::new);
    public static final RegistryObject<DiffuserBlock> DIFFUSER = ECBlocks.register("diffuser", DiffuserBlock::new);
    public static final RegistryObject<InfuserBlock> INFUSER = ECBlocks.register("infuser", InfuserBlock::new);
    public static final RegistryObject<BinderBlock> BINDER = ECBlocks.register("binder", BinderBlock::new);
    public static final RegistryObject<ImprovedBinderBlock> BINDER_IMPROVED = ECBlocks.register("binder_improved", ImprovedBinderBlock::new);
    public static final RegistryObject<CrystallizerBlock> CRYSTALLIZER = ECBlocks.register("crystallizer", CrystallizerBlock::new);
    public static final RegistryObject<InscriberBlock> INSCRIBER = ECBlocks.register("inscriber", InscriberBlock::new);
    public static final RegistryObject<WaterMillGrindstoneBlock> WATER_MILL_GRINDSTONE = ECBlocks.register("water_mill_grindstone", WaterMillGrindstoneBlock::new);
    public static final RegistryObject<AirMillGrindstoneBlock> AIR_MILL_GRINDSTONE = ECBlocks.register("air_mill_grindstone", AirMillGrindstoneBlock::new);
    public static final RegistryObject<WaterMillWoodSawBlock> WATER_MILL_WOOD_SAW = ECBlocks.register("water_mill_wood_saw", WaterMillWoodSawBlock::new);
    public static final RegistryObject<AirMillWoodSawBlock> AIR_MILL_WOOD_SAW = ECBlocks.register("air_mill_wood_saw", AirMillWoodSawBlock::new);
    public static final RegistryObject<PedestalBlock> FIRE_PEDESTAL = ECBlocks.register("pedestal_fire", () -> new PedestalBlock(ElementType.FIRE));
    public static final RegistryObject<PedestalBlock> WATER_PEDESTAL = ECBlocks.register("pedestal_water", () -> new PedestalBlock(ElementType.WATER));
    public static final RegistryObject<PedestalBlock> EARTH_PEDESTAL = ECBlocks.register("pedestal_earth", () -> new PedestalBlock(ElementType.EARTH));
    public static final RegistryObject<PedestalBlock> AIR_PEDESTAL = ECBlocks.register("pedestal_air", () -> new PedestalBlock(ElementType.AIR));
    public static final RegistryObject<PureInfuserBlock> PURE_INFUSER = ECBlocks.register("pureinfuser", PureInfuserBlock::new);
    public static final RegistryObject<FireFurnaceBlock> FIRE_FURNACE = ECBlocks.register("firefurnace", FireFurnaceBlock::new);
    public static final RegistryObject<FireBlastFurnaceBlock> FIRE_BLAST_FURNACE = ECBlocks.register("fireblastfurnace", FireBlastFurnaceBlock::new);
    public static final RegistryObject<PurifierBlock> PURIFIER = ECBlocks.register("purifier", PurifierBlock::new);
    public static final RegistryObject<ElementPipeBlock> PIPE_IMPAIRED = ECBlocks.register("elementpipe_impaired", () -> new ElementPipeBlock(ElementPipeBlock.PipeType.IMPAIRED));
    public static final RegistryObject<ElementPipeBlock> PIPE = ECBlocks.register("elementpipe", () -> new ElementPipeBlock(ElementPipeBlock.PipeType.STANDARD));
    public static final RegistryObject<ElementPipeBlock> PIPE_IMPROVED = ECBlocks.register("elementpipe_improved", () -> new ElementPipeBlock(ElementPipeBlock.PipeType.IMPROVED));
    public static final RegistryObject<ElementPipeBlock> PIPE_CREATIVE = ECBlocks.register("elementpipe_creative", () -> new ElementPipeBlock(ElementPipeBlock.PipeType.CREATIVE));
    public static final RegistryObject<RetrieverBlock> RETRIEVER = ECBlocks.register("instrument_retriever", RetrieverBlock::new);
    public static final RegistryObject<SorterBlock> SORTER = ECBlocks.register("sorter", SorterBlock::new);
    public static final RegistryObject<SpellDeskBlock> SPELL_DESK = ECBlocks.register("spell_desk", SpellDeskBlock::new);
    public static final RegistryObject<FirePylonBlock> FIRE_PYLON = ECBlocks.register("firepylon", FirePylonBlock::new);
    public static final RegistryObject<VacuumShrineBlock> VACUUM_SHRINE = ECBlocks.register("vacuumshrine", VacuumShrineBlock::new);
    public static final RegistryObject<GrowthShrineBlock> GROWTH_SHRINE = ECBlocks.register("growthshrine", GrowthShrineBlock::new);
    public static final RegistryObject<HarvestShrineBlock> HARVEST_SHRINE = ECBlocks.register("harvestshrine", HarvestShrineBlock::new);
    public static final RegistryObject<LumberShrineBlock> LUMBER_SHRINE = ECBlocks.register("lumbershrine", LumberShrineBlock::new);
    public static final RegistryObject<LavaShrineBlock> LAVA_SHRINE = ECBlocks.register("lavashrine", LavaShrineBlock::new);
    public static final RegistryObject<OreShrineBlock> ORE_SHRINE = ECBlocks.register("oreshrine", OreShrineBlock::new);
    public static final RegistryObject<OverloadShrineBlock> OVERLOAD_SHRINE = ECBlocks.register("overloadshrine", OverloadShrineBlock::new);
    public static final RegistryObject<SweetShrineBlock> SWEET_SHRINE = ECBlocks.register("sweetshrine", SweetShrineBlock::new);
    public static final RegistryObject<EnderLockShrineBlock> ENDER_LOCK_SHRINE = ECBlocks.register("enderlockshrine", EnderLockShrineBlock::new);
    public static final RegistryObject<BreedingShrineBlock> BREEDING_SHRINE = ECBlocks.register("breedingshrine", BreedingShrineBlock::new);
    public static final RegistryObject<GroveShrineBlock> GROVE_SHRINE = ECBlocks.register("groveshrine", GroveShrineBlock::new);
    public static final RegistryObject<SpringShrineBlock> SPRING_SHRINE = ECBlocks.register("springshrine", SpringShrineBlock::new);
    public static final RegistryObject<BuddingShrineBlock> BUDDING_SHRINE = ECBlocks.register("buddingshrine", BuddingShrineBlock::new);
    public static final RegistryObject<SpawningShrineBlock> SPAWNING_SHRINE = ECBlocks.register("spawningshrine", SpawningShrineBlock::new);
    public static final RegistryObject<AccelerationShrineUpgradeBlock> ACCELERATION_SHRINE_UPGRADE = ECBlocks.register("shrine_upgrade_acceleration", AccelerationShrineUpgradeBlock::new);
    public static final RegistryObject<OverclockedAccelerationShrineUpgradeBlock> OVERCLOCKED_ACCELERATION_SHRINE_UPGRADE = ECBlocks.register("shrine_upgrade_overclocked_acceleration", OverclockedAccelerationShrineUpgradeBlock::new);
    public static final RegistryObject<RangeShrineUpgradeBlock> RANGE_SHRINE_UPGRADE = ECBlocks.register("shrine_upgrade_range", RangeShrineUpgradeBlock::new);
    public static final RegistryObject<CapacityShrineUpgradeBlock> CAPACITY_SHRINE_UPGRADE = ECBlocks.register("shrine_upgrade_capacity", CapacityShrineUpgradeBlock::new);
    public static final RegistryObject<EfficiencyShrineUpgradeBlock> EFFICIENCY_SHRINE_UPGRADE = ECBlocks.register("shrine_upgrade_efficiency", EfficiencyShrineUpgradeBlock::new);
    public static final RegistryObject<StrengthShrineUpgradeBlock> STRENGTH_SHRINE_UPGRADE = ECBlocks.register("shrine_upgrade_strength", StrengthShrineUpgradeBlock::new);
    public static final RegistryObject<OptimizationShrineUpgradeBlock> OPTIMIZATION_SHRINE_UPGRADE = ECBlocks.register("shrine_upgrade_optimization", OptimizationShrineUpgradeBlock::new);
    public static final RegistryObject<FortuneShrineUpgradeBlock> FORTUNE_SHRINE_UPGRADE = ECBlocks.register("shrine_upgrade_fortune", FortuneShrineUpgradeBlock::new);
    public static final RegistryObject<SilkTouchShrineUpgradeBlock> SILK_TOUCH_SHRINE_UPGRADE = ECBlocks.register("shrine_upgrade_silk_touch", SilkTouchShrineUpgradeBlock::new);
    public static final RegistryObject<PlantingShrineUpgradeBlock> PLANTING_SHRINE_UPGRADE = ECBlocks.register("shrine_upgrade_planting", PlantingShrineUpgradeBlock::new);
    public static final RegistryObject<BonelessGrowthShrineUpgradeBlock> BONELESS_GROWTH_SHRINE_UPGRADE = ECBlocks.register("shrine_upgrade_boneless_growth", BonelessGrowthShrineUpgradeBlock::new);
    public static final RegistryObject<PickupShrineUpgradeBlock> PICKUP_SHRINE_UPGRADE = ECBlocks.register("shrine_upgrade_pickup", PickupShrineUpgradeBlock::new);
    public static final RegistryObject<VortexShrineUpgradeBlock> VORTEX_SHRINE_UPGRADE = ECBlocks.register("shrine_upgrade_vortex", VortexShrineUpgradeBlock::new);
    public static final RegistryObject<NectarShrineUpgradeBlock> NECTAR_SHRINE_UPGRADE = ECBlocks.register("shrine_upgrade_nectar", NectarShrineUpgradeBlock::new);
    public static final RegistryObject<MysticalGroveShrineUpgradeBlock> MYSTICAL_GROVE_SHRINE_UPGRADE = ECBlocks.register("shrine_upgrade_mystical_grove", MysticalGroveShrineUpgradeBlock::new);
    public static final RegistryObject<StemPollinationShrineUpgradeBlock> STEM_POLLINATION_SHRINE_UPGRADE = ECBlocks.register("shrine_upgrade_stem_pollination", StemPollinationShrineUpgradeBlock::new);
    public static final RegistryObject<ProtectionShrineUpgradeBlock> PROTECTION_SHRINE_UPGRADE = ECBlocks.register("shrine_upgrade_protection", ProtectionShrineUpgradeBlock::new);
    public static final RegistryObject<FillingShrineUpgradeBlock> FILLING_SHRINE_UPGRADE = ECBlocks.register("shrine_upgrade_filling", FillingShrineUpgradeBlock::new);
    public static final RegistryObject<SpringalineShrineUpgradeBlock> SPRINGALINE_SHRINE_UPGRADE = ECBlocks.register("shrine_upgrade_springaline", SpringalineShrineUpgradeBlock::new);
    public static final RegistryObject<CrystalHarvestShrineUpgradeBlock> CRYSTAL_HARVEST_SHRINE_UPGRADE = ECBlocks.register("shrine_upgrade_crystal_harvest", CrystalHarvestShrineUpgradeBlock::new);
    public static final RegistryObject<CrystalGrowthShrineUpgradeBlock> CRYSTAL_GROWTH_SHRINE_UPGRADE = ECBlocks.register("shrine_upgrade_crystal_growth", CrystalGrowthShrineUpgradeBlock::new);
    public static final RegistryObject<TranslocationShrineUpgradeBlock> TRANSLOCATION_SHRINE_UPGRADE = ECBlocks.register("shrine_upgrade_translocation", TranslocationShrineUpgradeBlock::new);
    public static final RegistryObject<SourceBlock> SOURCE = ECBlocks.register("source", SourceBlock::new);
    public static final RegistryObject<SourceDisplacementPlateBlock> FIRE_SOURCE_DISPLACEMENT_PLATE = ECBlocks.register("source_displacement_plate_fire", () -> new SourceDisplacementPlateBlock(ElementType.FIRE));
    public static final RegistryObject<SourceDisplacementPlateBlock> WATER_SOURCE_DISPLACEMENT_PLATE = ECBlocks.register("source_displacement_plate_water", () -> new SourceDisplacementPlateBlock(ElementType.WATER));
    public static final RegistryObject<SourceDisplacementPlateBlock> EARTH_SOURCE_DISPLACEMENT_PLATE = ECBlocks.register("source_displacement_plate_earth", () -> new SourceDisplacementPlateBlock(ElementType.EARTH));
    public static final RegistryObject<SourceDisplacementPlateBlock> AIR_SOURCE_DISPLACEMENT_PLATE = ECBlocks.register("source_displacement_plate_air", () -> new SourceDisplacementPlateBlock(ElementType.AIR));
    public static final RegistryObject<BrokenSourceDisplacementPlateBlock> BROKEN_SOURCE_DISPLACEMENT_PLATE = ECBlocks.register("broken_source_displacement_plate", BrokenSourceDisplacementPlateBlock::new);
    public static final RegistryObject<SourceBreederBlock> SOURCE_BREEDER = ECBlocks.register("source_breeder", SourceBreederBlock::new);
    public static final RegistryObject<SourceBreederPedestalBlock> SOURCE_BREEDER_PEDESTAL = ECBlocks.register("source_breeder_pedestal", SourceBreederPedestalBlock::new);
    public static final RegistryObject<TranslocationAnchorBlock> TRANSLOCATION_ANCHOR = ECBlocks.register("translocation_anchor", TranslocationAnchorBlock::new);
    public static final RegistryObject<DropExperienceBlock> CRYSTAL_ORE = ECBlocks.register("inert_crystal_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49996_)));
    public static final RegistryObject<DropExperienceBlock> DEEPSLATE_CRYSTAL_ORE = ECBlocks.register("deepslate_inert_crystal_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152468_)));
    public static final RegistryObject<Block> WHITE_ROCK = ECBlocks.registerSimple("whiterock", ECProperties.Blocks.WHITEROCK);
    public static final RegistryObject<SlabBlock> WHITE_ROCK_SLAB = ECBlocks.registerSlab(WHITE_ROCK, ECProperties.Blocks.WHITEROCK);
    public static final RegistryObject<StairBlock> WHITE_ROCK_STAIRS = ECBlocks.registerStairs(WHITE_ROCK, ECProperties.Blocks.WHITEROCK);
    public static final RegistryObject<WallBlock> WHITE_ROCK_WALL = ECBlocks.registerWall(WHITE_ROCK, ECProperties.Blocks.WHITEROCK);
    public static final RegistryObject<FenceBlock> WHITE_ROCK_FENCE = ECBlocks.registerFence(WHITE_ROCK, ECProperties.Blocks.WHITEROCK);
    public static final RegistryObject<Block> WHITE_ROCK_BRICK = ECBlocks.registerSimple("whiterock_brick", ECProperties.Blocks.WHITEROCK);
    public static final RegistryObject<SlabBlock> WHITE_ROCK_BRICK_SLAB = ECBlocks.registerSlab(WHITE_ROCK_BRICK, ECProperties.Blocks.WHITEROCK);
    public static final RegistryObject<StairBlock> WHITE_ROCK_BRICK_STAIRS = ECBlocks.registerStairs(WHITE_ROCK_BRICK, ECProperties.Blocks.WHITEROCK);
    public static final RegistryObject<WallBlock> WHITE_ROCK_BRICK_WALL = ECBlocks.registerWall(WHITE_ROCK_BRICK, ECProperties.Blocks.WHITEROCK);
    public static final RegistryObject<Block> MOSSY_WHITE_ROCK = ECBlocks.registerSimple("whiterock_mossy", ECProperties.Blocks.WHITEROCK);
    public static final RegistryObject<SlabBlock> MOSSY_WHITE_ROCK_SLAB = ECBlocks.registerSlab(MOSSY_WHITE_ROCK, ECProperties.Blocks.WHITEROCK);
    public static final RegistryObject<StairBlock> MOSSY_WHITE_ROCK_STAIRS = ECBlocks.registerStairs(MOSSY_WHITE_ROCK, ECProperties.Blocks.WHITEROCK);
    public static final RegistryObject<WallBlock> MOSSY_WHITE_ROCK_WALL = ECBlocks.registerWall(MOSSY_WHITE_ROCK, ECProperties.Blocks.WHITEROCK);
    public static final RegistryObject<Block> BURNT_WHITE_ROCK = ECBlocks.registerSimple("whiterock_burnt", ECProperties.Blocks.WHITEROCK);
    public static final RegistryObject<SlabBlock> BURNT_WHITE_ROCK_SLAB = ECBlocks.registerSlab(BURNT_WHITE_ROCK, ECProperties.Blocks.WHITEROCK);
    public static final RegistryObject<StairBlock> BURNT_WHITE_ROCK_STAIRS = ECBlocks.registerStairs(BURNT_WHITE_ROCK, ECProperties.Blocks.WHITEROCK);
    public static final RegistryObject<WallBlock> BURNT_WHITE_ROCK_WALL = ECBlocks.registerWall(BURNT_WHITE_ROCK, ECProperties.Blocks.WHITEROCK);
    public static final RegistryObject<Block> PURE_ROCK = ECBlocks.registerSimple("purerock", ECProperties.Blocks.PUREROCK);
    public static final RegistryObject<SlabBlock> PURE_ROCK_SLAB = ECBlocks.registerSlab(PURE_ROCK, ECProperties.Blocks.PUREROCK);
    public static final RegistryObject<StairBlock> PURE_ROCK_STAIRS = ECBlocks.registerStairs(PURE_ROCK, ECProperties.Blocks.PUREROCK);
    public static final RegistryObject<WallBlock> PURE_ROCK_WALL = ECBlocks.registerWall(PURE_ROCK, ECProperties.Blocks.PUREROCK);
    public static final RegistryObject<GlassBlock> BURNT_GLASS = ECBlocks.registerGlass("burnt_glass");
    public static final RegistryObject<IronBarsBlock> BURNT_GLASS_PANE = ECBlocks.registerGlassPane(BURNT_GLASS);
    public static final RegistryObject<Block> DRENCHED_IRON_BLOCK = ECBlocks.registerSimple("drenched_iron_block", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_));
    public static final RegistryObject<Block> SWIFT_ALLOY_BLOCK = ECBlocks.registerSimple("swift_alloy_block", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50074_));
    public static final RegistryObject<Block> FIREITE_BLOCK = ECBlocks.registerSimple("fireite_block", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50721_));
    public static final RegistryObject<Block> INERT_CRYSTAL_BLOCK = ECBlocks.registerSimple("inertcrystal_block");
    public static final RegistryObject<Block> FIRE_CRYSTAL_BLOCK = ECBlocks.registerSimple("firecrystal_block");
    public static final RegistryObject<Block> WATER_CRYSTAL_BLOCK = ECBlocks.registerSimple("watercrystal_block");
    public static final RegistryObject<Block> EARTH_CRYSTAL_BLOCK = ECBlocks.registerSimple("earthcrystal_block");
    public static final RegistryObject<Block> AIR_CRYSTAL_BLOCK = ECBlocks.registerSimple("aircrystal_block");
    public static final RegistryObject<AmethystBlock> SPRINGALINE_BLOCK = ECBlocks.register("springaline_block", () -> new AmethystBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_)));
    public static final RegistryObject<AmethystClusterBlock> SPRINGALINE_CLUSTER = ECBlocks.register("springaline_cluster", () -> new AmethystClusterBlock(7, 3, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152492_)));
    public static final RegistryObject<AmethystClusterBlock> LARGE_SPRINGALINE_BUD = ECBlocks.register("large_springaline_bud", () -> new AmethystClusterBlock(5, 3, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152493_)));
    public static final RegistryObject<AmethystClusterBlock> MEDIUM_SPRINGALINE_BUD = ECBlocks.register("medium_springaline_bud", () -> new AmethystClusterBlock(4, 3, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152494_)));
    public static final RegistryObject<AmethystClusterBlock> SMALL_SPRINGALINE_BUD = ECBlocks.register("small_springaline_bud", () -> new AmethystClusterBlock(3, 4, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152495_)));
    public static final RegistryObject<GlassBlock> SPRINGALINE_GLASS = ECBlocks.registerGlass("springaline_glass");
    public static final RegistryObject<IronBarsBlock> SPRINGALINE_GLASS_PANE = ECBlocks.registerGlassPane(SPRINGALINE_GLASS);
    public static final RegistryObject<Block> SPRINGALINE_LANTERN = ECBlocks.register("springaline_lantern", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283942_).m_60978_(0.3f).m_60918_(SoundType.f_56744_).m_60953_(s -> 15)));

    private ECBlocks() {
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> block) {
        return DEFERRED_REGISTER.register(name, block);
    }

    private static RegistryObject<Block> registerSimple(String name, BlockBehaviour.Properties properties) {
        return DEFERRED_REGISTER.register(name, () -> new Block(properties));
    }

    private static RegistryObject<Block> registerSimple(String name) {
        return DEFERRED_REGISTER.register(name, () -> new Block(ECProperties.Blocks.DEFAULT_BLOCK_PROPERTIES));
    }

    private static <T extends Block> RegistryObject<SlabBlock> registerSlab(RegistryObject<T> block, BlockBehaviour.Properties properties) {
        return DEFERRED_REGISTER.register(block.getId().m_135815_() + "_slab", () -> new SlabBlock(properties));
    }

    private static <T extends Block> RegistryObject<StairBlock> registerStairs(RegistryObject<T> block, BlockBehaviour.Properties properties) {
        return DEFERRED_REGISTER.register(block.getId().m_135815_() + "_stairs", () -> new StairBlock(() -> ((Block)block.get()).m_49966_(), properties));
    }

    private static <T extends Block> RegistryObject<WallBlock> registerWall(RegistryObject<T> block, BlockBehaviour.Properties properties) {
        return DEFERRED_REGISTER.register(block.getId().m_135815_() + "_wall", () -> new WallBlock(properties));
    }

    private static <T extends Block> RegistryObject<FenceBlock> registerFence(RegistryObject<T> block, BlockBehaviour.Properties properties) {
        return DEFERRED_REGISTER.register(block.getId().m_135815_() + "_fence", () -> new FenceBlock(properties));
    }

    private static RegistryObject<GlassBlock> registerGlass(String name) {
        return DEFERRED_REGISTER.register(name, () -> new GlassBlock(ECProperties.Blocks.GLASS));
    }

    private static RegistryObject<IronBarsBlock> registerGlassPane(RegistryObject<? extends GlassBlock> block) {
        return DEFERRED_REGISTER.register(block.getId().m_135815_() + "_pane", () -> new IronBarsBlock(ECProperties.Blocks.GLASS_PANE));
    }

    public static void register(IEventBus bus) {
        DEFERRED_REGISTER.register(bus);
    }
}

