/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.RegistryObject;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;
import sirttas.elementalcraft.container.ECContainerHelper;
import sirttas.elementalcraft.property.ECProperties;

public abstract class AbstractECEntityBlock
extends BaseEntityBlock {
    protected AbstractECEntityBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected AbstractECEntityBlock() {
        this(ECProperties.Blocks.DEFAULT_BLOCK_PROPERTIES);
    }

    @Nonnull
    @Deprecated
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    @Deprecated
    public void m_6810_(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            this.dropItems(level, pos);
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    private void dropItems(Level level, BlockPos pos) {
        IItemHandler inv = ECContainerHelper.getItemHandlerAt((BlockGetter)level, pos, null);
        if (inv != null) {
            for (int i = 0; i < inv.getSlots(); ++i) {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)inv.getStackInSlot(i));
            }
            level.m_46717_(pos, (Block)this);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return !level.f_46443_ ? (l, p, s, be) -> AbstractECEntityBlock.sendUpdate(be) : null;
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createECTicker(Level level, BlockEntityType<A> type, RegistryObject<BlockEntityType<E>> expectedType, BlockEntityTicker<? super E> ticker) {
        return AbstractECEntityBlock.createECTicker(level, type, (BlockEntityType)expectedType.get(), ticker);
    }

    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createECTicker(Level level, BlockEntityType<A> type, BlockEntityType<E> expectedType, BlockEntityTicker<? super E> ticker) {
        return AbstractECEntityBlock.m_152132_(type, expectedType, !level.f_46443_ ? AbstractECEntityBlock.createUpdateTicker(ticker) : ticker);
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createECServerTicker(Level level, BlockEntityType<A> type, RegistryObject<BlockEntityType<E>> expectedType, BlockEntityTicker<? super E> ticker) {
        return level.f_46443_ ? null : AbstractECEntityBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)expectedType.get()), AbstractECEntityBlock.createUpdateTicker(ticker));
    }

    private static <E extends BlockEntity> BlockEntityTicker<? super E> createUpdateTicker(BlockEntityTicker<? super E> ticker) {
        return (l, pos, state, be) -> {
            ticker.m_155252_(l, pos, state, be);
            AbstractECEntityBlock.sendUpdate(be);
        };
    }

    private static void sendUpdate(BlockEntity blockEntity) {
        if (blockEntity instanceof AbstractECBlockEntity) {
            AbstractECBlockEntity ecBlockEntity = (AbstractECBlockEntity)blockEntity;
            ecBlockEntity.sendUpdate();
        }
    }

    @Deprecated
    public boolean m_7923_(@Nonnull BlockState state) {
        return true;
    }
}

