/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.rune;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.api.upgrade.AbstractUpgrade;

public class Rune
extends AbstractUpgrade<BonusType> {
    public static final Codec<Rune> CODEC = RecordCodecBuilder.create(builder -> Rune.codec(builder, BonusType.CODEC).and(builder.group((App)ResourceLocation.f_135803_.fieldOf("model").forGetter(Rune::getModelName), (App)ResourceLocation.f_135803_.fieldOf("effect_sprite").forGetter(Rune::getSpriteName))).apply((Applicative)builder, Rune::new));
    private final ResourceLocation modelName;
    private final ResourceLocation fxSpriteName;
    @OnlyIn(value=Dist.CLIENT)
    private Material sprite;

    private Rune(IBlockPosPredicate predicate, Map<BonusType, Float> bonuses, int maxAmount, ResourceLocation modelName, ResourceLocation fxSpriteName) {
        super(predicate, new EnumMap<BonusType, Float>(bonuses), maxAmount);
        this.modelName = modelName;
        this.fxSpriteName = fxSpriteName;
    }

    public boolean canUpgrade(@Nonnull LevelReader level, @Nonnull BlockPos pos, @Nullable Direction direction, IRuneHandler handler) {
        return handler.getRuneCount() < handler.getMaxRunes() && this.canUpgrade(level, pos, direction, handler.getRuneCount(this));
    }

    public void addInformation(List<Component> tooltip) {
        this.bonuses.forEach((type, multiplier) -> tooltip.add((Component)Component.m_237110_((String)("rune_bonus.elementalcraft." + type.m_7912_()), (Object[])new Object[]{this.formatMultiplier((Float)multiplier)}).m_130940_(multiplier.floatValue() > 0.0f ? ChatFormatting.BLUE : ChatFormatting.RED)));
        if (this.maxAmount > 0) {
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237110_((String)"tooltip.elementalcraft.max_amount", (Object[])new Object[]{this.maxAmount}).m_130940_(ChatFormatting.YELLOW));
        }
    }

    private String formatMultiplier(Float multiplier) {
        return String.format("%+d%%", Math.round(multiplier.floatValue() * 100.0f));
    }

    public ResourceLocation getModelName() {
        return this.modelName;
    }

    public ResourceLocation getSpriteName() {
        return this.fxSpriteName;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Material getSprite() {
        if (this.sprite == null) {
            this.sprite = ForgeHooksClient.getBlockMaterial((ResourceLocation)this.fxSpriteName);
        }
        return this.sprite;
    }

    public Component getDisplayName() {
        ResourceLocation id = this.getId();
        return Component.m_237115_((String)("elementalcraft_rune." + id.m_135827_() + "." + id.m_135815_()));
    }

    public boolean is(ResourceKey<Rune> key) {
        return key.m_135782_().equals((Object)this.getId());
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Rune) {
            return super.equals(other);
        }
        return false;
    }

    public static Rune merge(Stream<Rune> runes) {
        AtomicReference atomicValue = new AtomicReference();
        runes.forEach(rune -> {
            Rune value = (Rune)atomicValue.get();
            if (value == null) {
                atomicValue.set(rune);
            } else {
                value.merge(rune);
            }
        });
        return (Rune)atomicValue.get();
    }

    public static enum BonusType implements StringRepresentable
    {
        NONE("none"),
        SPEED("speed"),
        ELEMENT_PRESERVATION("element_preservation"),
        LUCK("luck");

        public static final Codec<BonusType> CODEC;
        private final String name;

        private BonusType(String name) {
            this.name = name;
        }

        @Nonnull
        public String m_7912_() {
            return this.name;
        }

        public static BonusType byName(String name) {
            for (BonusType bonusType : BonusType.values()) {
                if (!bonusType.name.equals(name)) continue;
                return bonusType;
            }
            return NONE;
        }

        static {
            CODEC = StringRepresentable.m_216439_(BonusType::values);
        }
    }

    public static class Builder {
        public static final Encoder<Builder> ENCODER = CODEC.comap(builder -> new Rune(builder.predicate, builder.bonuses, builder.maxAmount, builder.model, builder.sprite));
        private IBlockPosPredicate predicate = null;
        private final Map<BonusType, Float> bonuses = new EnumMap<BonusType, Float>(BonusType.class);
        private int maxAmount = 0;
        private ResourceLocation model = null;
        private ResourceLocation sprite = null;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder match(Block ... block) {
            return this.predicate(IBlockPosPredicate.match((Block[])block));
        }

        public Builder match(TagKey<Block> tag) {
            return this.predicate(IBlockPosPredicate.match(tag));
        }

        public Builder predicate(IBlockPosPredicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public Builder max(int max) {
            this.maxAmount = max;
            return this;
        }

        public Builder model(ItemModelBuilder model) {
            ResourceLocation modelLoc = model.getLocation();
            this.model = new ResourceLocation(modelLoc.m_135827_(), modelLoc.m_135815_());
            return this;
        }

        public Builder sprite(ResourceLocation sprite) {
            this.sprite = sprite;
            return this;
        }

        public Builder addBonus(BonusType type, float value) {
            this.bonuses.put(type, Float.valueOf(value));
            return this;
        }
    }
}

