/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import java.util.Random;
import java.util.function.Supplier;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.client.renderer.entity.custom.CrowEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.OwlEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class TailFanPacket {
    int sourceId;
    int duration;

    public TailFanPacket(Entity entity, int duration) {
        this.sourceId = entity.m_19879_();
        this.duration = duration;
    }

    public TailFanPacket(FriendlyByteBuf buf) {
        this.sourceId = buf.readInt();
        this.duration = buf.readInt();
    }

    public static void encode(TailFanPacket object, FriendlyByteBuf buffer) {
        buffer.writeInt(object.sourceId);
        buffer.writeInt(object.duration);
    }

    public static TailFanPacket decode(FriendlyByteBuf buffer) {
        return new TailFanPacket(buffer);
    }

    public static void consume(TailFanPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level world;
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                world = Hexerei.proxy.getLevel();
            } else {
                if (((NetworkEvent.Context)ctx.get()).getSender() == null) {
                    return;
                }
                world = ((NetworkEvent.Context)ctx.get()).getSender().m_9236_();
            }
            if (world.m_6815_(packet.sourceId) != null) {
                Entity patt1998$temp;
                Entity patt1731$temp = world.m_6815_(packet.sourceId);
                if (patt1731$temp instanceof CrowEntity) {
                    CrowEntity crow = (CrowEntity)patt1731$temp;
                    crow.tailFan = true;
                    crow.tailFanTimer = 15;
                    crow.tailFanTiltAngle = 20 + new Random().nextInt(20);
                }
                if ((patt1998$temp = world.m_6815_(packet.sourceId)) instanceof OwlEntity) {
                    OwlEntity owl = (OwlEntity)patt1998$temp;
                    owl.tailFanAnimation.start();
                    owl.tailFanAnimation.activeTimer = packet.duration;
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

