/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import java.util.function.Supplier;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.client.renderer.entity.custom.CrowEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.OwlEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class HeadTiltPacket {
    int sourceId;
    int duration;
    float xTilt;
    float zTilt;

    public HeadTiltPacket(Entity entity) {
        this.sourceId = entity.m_19879_();
        this.duration = 15;
        this.xTilt = 0.0f;
        this.zTilt = 0.0f;
    }

    public HeadTiltPacket(Entity entity, int duration, float xTilt, float zTilt) {
        this.sourceId = entity.m_19879_();
        this.duration = duration;
        this.xTilt = xTilt;
        this.zTilt = zTilt;
    }

    public HeadTiltPacket(FriendlyByteBuf buf) {
        this.sourceId = buf.readInt();
        this.duration = buf.readInt();
        this.xTilt = buf.readFloat();
        this.zTilt = buf.readFloat();
    }

    public static void encode(HeadTiltPacket object, FriendlyByteBuf buffer) {
        buffer.writeInt(object.sourceId);
        buffer.writeInt(object.duration);
        buffer.writeFloat(object.xTilt);
        buffer.writeFloat(object.zTilt);
    }

    public static HeadTiltPacket decode(FriendlyByteBuf buffer) {
        return new HeadTiltPacket(buffer);
    }

    public static void consume(HeadTiltPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level world;
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                world = Hexerei.proxy.getLevel();
            } else {
                if (((NetworkEvent.Context)ctx.get()).getSender() == null) {
                    return;
                }
                world = ((NetworkEvent.Context)ctx.get()).getSender().m_9236_();
            }
            if (world.m_6815_(packet.sourceId) != null) {
                Entity patt2300$temp;
                Entity patt2163$temp = world.m_6815_(packet.sourceId);
                if (patt2163$temp instanceof CrowEntity) {
                    CrowEntity crow = (CrowEntity)patt2163$temp;
                    crow.peck();
                }
                if ((patt2300$temp = world.m_6815_(packet.sourceId)) instanceof OwlEntity) {
                    OwlEntity owl = (OwlEntity)patt2300$temp;
                    owl.headTiltAnimation.start();
                    owl.headTiltAnimation.xTiltTarget = packet.xTilt;
                    owl.headTiltAnimation.zTiltTarget = packet.zTilt;
                    owl.headTiltAnimation.activeTimer = packet.duration;
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

