/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.item.custom.CustomItemRenderer;
import net.joefoxe.hexerei.item.custom.HerbJarItemRenderer;
import net.joefoxe.hexerei.items.JarHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class HerbJarItem
extends BlockItem
implements DyeableLeatherItem {
    public HerbJarItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, world, tooltip, flagIn);
        CompoundTag inv = stack.m_41784_().m_128469_("Inventory");
        ListTag tagList = inv.m_128437_("Items", 10);
        if (Screen.m_96638_()) {
            if (tagList.size() >= 1) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.herb_jar_shift_4").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.herb_jar_shift_5").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.herb_jar_shift_6").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            }
            if (tagList.size() < 1) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.herb_jar_shift_4").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.herb_jar_shift_5").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.herb_jar_shift_6").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.herb_jar_shift_7").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            }
        }
    }

    public InteractionResult m_40576_(BlockPlaceContext context) {
        return super.m_40576_(context);
    }

    public void m_6192_(Map<Block, Item> pBlockToItemMap, Item pItem) {
        super.m_6192_(pBlockToItemMap, pItem);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack p_150775_) {
        JarHandler handler = this.createHandler();
        int count = HerbJarItem.getContentsExtra(p_150775_);
        ItemStack stack = HerbJarItem.getContents(p_150775_);
        stack.m_41764_(count);
        handler.setStackInSlot(0, stack);
        return Optional.of(new HerbJarToolTip(handler));
    }

    private JarHandler createHandler() {
        return new JarHandler(1, 1024);
    }

    private static ItemStack getContents(ItemStack p_150783_) {
        CompoundTag compoundtag = p_150783_.m_41783_();
        if (compoundtag == null) {
            return ItemStack.f_41583_;
        }
        return ItemStack.m_41712_((CompoundTag)compoundtag.m_128469_("Inventory").m_128437_("Items", 10).m_128728_(0));
    }

    private static int getContentsExtra(ItemStack p_150783_) {
        CompoundTag compoundtag = p_150783_.m_41783_();
        if (compoundtag == null) {
            return 0;
        }
        return compoundtag.m_128469_("Inventory").m_128437_("Items", 10).m_128728_(0).m_128451_("ExtendedCount");
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        final CustomItemRenderer renderer = this.createItemRenderer();
        if (renderer != null) {
            consumer.accept(new IClientItemExtensions(){

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return renderer.getRenderer();
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public CustomItemRenderer createItemRenderer() {
        return new HerbJarItemRenderer();
    }

    public record HerbJarToolTip(JarHandler jarHandler) implements TooltipComponent
    {
    }
}

