/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.appliede.me.key;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import gripe._90.appliede.me.key.EMCKeyType;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public final class EMCKey
extends AEKey {
    public static final EMCKey BASE = new EMCKey(1);
    private final int tier;

    private EMCKey(int tier) {
        if (tier <= 0) {
            throw new IllegalArgumentException("Tier must be non-negative");
        }
        this.tier = tier;
    }

    public static EMCKey tier(int tier) {
        return tier == 1 ? BASE : new EMCKey(tier);
    }

    public int getTier() {
        return this.tier;
    }

    public AEKeyType getType() {
        return EMCKeyType.TYPE;
    }

    public AEKey dropSecondary() {
        return this;
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("tier", this.tier);
        return tag;
    }

    public Object getPrimaryKey() {
        return this.tier;
    }

    public ResourceLocation getId() {
        return new ResourceLocation("projecte", "emc_" + this.tier);
    }

    public void writeToPacket(FriendlyByteBuf data) {
        data.m_130130_(this.tier);
    }

    protected Component computeDisplayName() {
        return Component.m_237110_((String)("key.appliede.emc" + (this.tier == 1 ? "" : "_tiered")), (Object[])new Object[]{this.tier});
    }

    public void addDrops(long l, List<ItemStack> list, Level level, BlockPos blockPos) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof EMCKey)) return false;
        EMCKey key = (EMCKey)((Object)obj);
        if (this.tier != key.tier) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hashCode(this.tier);
    }
}

