/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.data;

import de.ellpeck.naturesaura.data.BiomeModifiers;
import de.ellpeck.naturesaura.data.BlockLootProvider;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.data.BlockTagProvider;
import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.data.ItemTagProvider;
import de.ellpeck.naturesaura.gen.ModFeatures;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModData {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput out = gen.getPackOutput();
        CompletableFuture lookup = event.getLookupProvider();
        ExistingFileHelper existing = event.getExistingFileHelper();
        BlockTagProvider blockTags = new BlockTagProvider(out, lookup, existing);
        gen.addProvider(event.includeServer(), (DataProvider)blockTags);
        gen.addProvider(event.includeServer(), (DataProvider)new ItemTagProvider(out, lookup, blockTags.m_274426_(), existing));
        gen.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(out, Set.of(), List.of(new LootTableProvider.SubProviderEntry(BlockLootProvider::new, LootContextParamSets.f_81421_))));
        gen.addProvider(event.includeServer(), (DataProvider)new BlockStateGenerator(out, existing));
        gen.addProvider(event.includeServer(), (DataProvider)new ItemModelGenerator(out, existing));
        gen.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(out, CompletableFuture.supplyAsync(ModData::getProvider), Set.of("naturesaura")));
    }

    private static HolderLookup.Provider getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.m_254916_(Registries.f_256911_, ModFeatures.Configured::bootstrap);
        registryBuilder.m_254916_(Registries.f_256988_, ModFeatures.Placed::bootstrap);
        registryBuilder.m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, BiomeModifiers::bootstrap);
        registryBuilder.m_254916_(Registries.f_256952_, context -> {});
        RegistryAccess.Frozen regAccess = RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_);
        return registryBuilder.m_254929_((RegistryAccess)regAccess, VanillaRegistries.m_255371_());
    }
}

