/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.multi;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.multiblock.IMultiblock;
import de.ellpeck.naturesaura.api.multiblock.Matcher;
import de.ellpeck.naturesaura.compat.patchouli.PatchouliCompat;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class Multiblock
implements IMultiblock {
    private final ResourceLocation name;
    private final Map<BlockPos, Matcher> matchers = new HashMap<BlockPos, Matcher>();
    private final int width;
    private final int height;
    private final int depth;
    private final int xOffset;
    private final int yOffset;
    private final int zOffset;
    private final char[][][] rawPattern;

    public Multiblock(ResourceLocation name, String[][] pattern, Object ... rawMatchers) {
        this.name = name;
        int width = -1;
        this.height = pattern.length;
        int depth = -1;
        int xOff = 0;
        int yOff = 0;
        int zOff = 0;
        char[][][] raw = null;
        for (int i = 0; i < pattern.length; ++i) {
            String[] row = pattern[i];
            if (width < 0) {
                width = row.length;
            } else if (row.length != width) {
                throw new IllegalArgumentException();
            }
            for (int j = 0; j < row.length; ++j) {
                String column = row[j];
                if (depth < 0) {
                    depth = column.length();
                } else if (column.length() != depth) {
                    throw new IllegalArgumentException();
                }
                if (raw == null) {
                    raw = new char[width][this.height][depth];
                }
                for (int k = 0; k < column.length(); ++k) {
                    char c;
                    raw[k][this.height - 1 - i][j] = c = column.charAt(k);
                    if (c != '0') continue;
                    xOff = k;
                    yOff = this.height - 1 - i;
                    zOff = j;
                }
            }
        }
        this.depth = depth;
        this.width = width;
        this.xOffset = xOff;
        this.yOffset = yOff;
        this.zOffset = zOff;
        this.rawPattern = raw;
        HashMap<Character, Matcher> matchers = new HashMap<Character, Matcher>();
        for (int i = 0; i < rawMatchers.length; i += 2) {
            char c = ((Character)rawMatchers[i]).charValue();
            if (matchers.containsKey(Character.valueOf(c))) continue;
            Object value = rawMatchers[i + 1];
            if (value instanceof BlockState) {
                BlockState state2 = (BlockState)value;
                matchers.put(Character.valueOf(c), new Matcher(state2, (level, start, offset, pos, other, otherC) -> other == state2));
                continue;
            }
            if (value instanceof Block) {
                Block block = (Block)value;
                matchers.put(Character.valueOf(c), new Matcher(block.m_49966_(), (level, start, offset, pos, state, otherC) -> state.m_60734_() == block));
                continue;
            }
            matchers.put(Character.valueOf(c), (Matcher)value);
        }
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.depth; ++z) {
                    Matcher matcher = (Matcher)matchers.get(Character.valueOf(this.rawPattern[x][y][z]));
                    if (matcher == null) {
                        throw new IllegalStateException();
                    }
                    if (matcher.check() == null) continue;
                    this.matchers.put(new BlockPos(x, y, z), matcher);
                }
            }
        }
        PatchouliCompat.addPatchouliMultiblock(name, pattern, rawMatchers);
        NaturesAuraAPI.MULTIBLOCKS.put(this.name, this);
    }

    @Override
    public boolean isComplete(Level level, BlockPos center) {
        BlockPos start = this.getStart(center);
        return this.forEach(center, '\u0000', (pos, matcher) -> {
            BlockPos offset = pos.m_121996_((Vec3i)start);
            return matcher.check().matches(level, start, offset, (BlockPos)pos, level.m_8055_(pos), this.getChar(offset));
        });
    }

    @Override
    public boolean forEach(BlockPos center, char c, BiFunction<BlockPos, Matcher, Boolean> function) {
        BlockPos start = this.getStart(center);
        for (Map.Entry<BlockPos, Matcher> entry : this.matchers.entrySet()) {
            BlockPos offset = entry.getKey();
            if (c != '\u0000' && this.getChar(offset) != c || function.apply(start.m_121955_((Vec3i)offset), entry.getValue()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public BlockPos getStart(BlockPos center) {
        return center.m_7918_(-this.xOffset, -this.yOffset, -this.zOffset);
    }

    @Override
    public char getChar(BlockPos offset) {
        return this.rawPattern[offset.m_123341_()][offset.m_123342_()][offset.m_123343_()];
    }

    @Override
    public ResourceLocation getName() {
        return this.name;
    }

    @Override
    public Map<BlockPos, Matcher> getMatchers() {
        return this.matchers;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getXOffset() {
        return this.xOffset;
    }

    @Override
    public int getYOffset() {
        return this.yOffset;
    }

    @Override
    public int getZOffset() {
        return this.zOffset;
    }

    @Override
    public char[][][] getRawPattern() {
        return this.rawPattern;
    }
}

