/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.util.MekanismUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class FuelInventorySlot
extends BasicInventorySlot {
    public static FuelInventorySlot forFuel(ToIntFunction<@NotNull ItemStack> fuelValue, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(fuelValue, "Fuel value calculator cannot be null");
        return new FuelInventorySlot(stack -> fuelValue.applyAsInt((ItemStack)stack) == 0, stack -> fuelValue.applyAsInt((ItemStack)stack) > 0, (Predicate<ItemStack>)alwaysTrue, listener, x, y);
    }

    private FuelInventorySlot(Predicate<@NotNull ItemStack> canExtract, Predicate<@NotNull ItemStack> canInsert, Predicate<@NotNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        super((ItemStack stack, AutomationType automationType) -> automationType == AutomationType.MANUAL || canExtract.test((ItemStack)stack), (ItemStack stack, AutomationType automationType) -> canInsert.test((ItemStack)stack), validator, listener, x, y);
    }

    public int burn() {
        if (this.isEmpty()) {
            return 0;
        }
        int burnTime = ForgeHooks.getBurnTime((ItemStack)this.current, null) / 2;
        if (burnTime > 0) {
            if (this.current.hasCraftingRemainingItem()) {
                if (this.current.m_41613_() > 1) {
                    return 0;
                }
                this.setStack(this.current.getCraftingRemainingItem());
            } else {
                MekanismUtils.logMismatchedStackSize(this.shrinkStack(1, Action.EXECUTE), 1L);
            }
        }
        return burnTime;
    }
}

