/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.transmitter;

import mekanism.api.tier.BaseTier;
import mekanism.common.block.attribute.AttributeTier;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.block.interfaces.ITypeBlock;
import mekanism.common.block.transmitter.BlockLargeTransmitter;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tier.TransporterTier;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporter;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporterBase;

public class BlockLogisticalTransporter
extends BlockLargeTransmitter
implements IHasTileEntity<TileEntityLogisticalTransporterBase>,
ITypeBlock {
    private final TransporterTier tier;

    public BlockLogisticalTransporter(TransporterTier tier) {
        super(properties -> properties.m_284180_(tier.getBaseTier().getMapColor()));
        this.tier = tier;
    }

    @Override
    protected BaseTier getBaseTier() {
        return this.tier.getBaseTier();
    }

    @Override
    public BlockType getType() {
        return AttributeTier.getPassthroughType(this.tier);
    }

    @Override
    public TileEntityTypeRegistryObject<TileEntityLogisticalTransporter> getTileType() {
        return switch (this.tier) {
            default -> throw new IncompatibleClassChangeError();
            case TransporterTier.ADVANCED -> MekanismTileEntityTypes.ADVANCED_LOGISTICAL_TRANSPORTER;
            case TransporterTier.ELITE -> MekanismTileEntityTypes.ELITE_LOGISTICAL_TRANSPORTER;
            case TransporterTier.ULTIMATE -> MekanismTileEntityTypes.ULTIMATE_LOGISTICAL_TRANSPORTER;
            case TransporterTier.BASIC -> MekanismTileEntityTypes.BASIC_LOGISTICAL_TRANSPORTER;
        };
    }
}

