/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.obj;

import java.util.Collections;
import java.util.Objects;
import mekanism.client.model.data.TransmitterModelData;
import mekanism.client.render.obj.VisibleModelConfiguration;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.transmitter.ConnectionType;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransmitterModelConfiguration
extends VisibleModelConfiguration {
    @NotNull
    private final IconStatus iconStatus;

    public TransmitterModelConfiguration(IGeometryBakingContext internal, String piece, @NotNull IconStatus iconStatus) {
        super(internal, Collections.singletonList(piece));
        this.iconStatus = Objects.requireNonNull(iconStatus, "Icon status must be present.");
    }

    @Nullable
    private static Direction directionForPiece(@NotNull String piece) {
        if (piece.endsWith("down")) {
            return Direction.DOWN;
        }
        if (piece.endsWith("up")) {
            return Direction.UP;
        }
        if (piece.endsWith("north")) {
            return Direction.NORTH;
        }
        if (piece.endsWith("south")) {
            return Direction.SOUTH;
        }
        if (piece.endsWith("east")) {
            return Direction.EAST;
        }
        if (piece.endsWith("west")) {
            return Direction.WEST;
        }
        return null;
    }

    private String adjustTextureName(String name) {
        Direction direction = TransmitterModelConfiguration.directionForPiece(name);
        if (direction != null) {
            if (this.iconStatus != IconStatus.NO_SHOW) {
                String string = name = name.contains("glass") ? "#side_glass" : "#side";
            }
            if (MekanismConfig.client.opaqueTransmitters.get()) {
                if (name.startsWith("#side")) {
                    return name + "_opaque";
                }
                if (name.startsWith("#center")) {
                    return name.contains("glass") ? "#center_glass_opaque" : "#center_opaque";
                }
            }
            return name;
        }
        if (MekanismConfig.client.opaqueTransmitters.get() && name.startsWith("#side")) {
            return name + "_opaque";
        }
        return name;
    }

    public static IconStatus getIconStatus(TransmitterModelData modelData, Direction side, ConnectionType connectionType) {
        if (modelData instanceof TransmitterModelData.Diversion || connectionType != ConnectionType.NONE) {
            return IconStatus.NO_SHOW;
        }
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP -> TransmitterModelConfiguration.getStatus(modelData, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST);
            case Direction.NORTH, Direction.SOUTH -> TransmitterModelConfiguration.getStatus(modelData, Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST);
            case Direction.WEST, Direction.EAST -> TransmitterModelConfiguration.getStatus(modelData, Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH);
        };
    }

    private static IconStatus getStatus(TransmitterModelData modelData, Direction a, Direction b, Direction c, Direction d) {
        boolean hasA = modelData.getConnectionType(a) != ConnectionType.NONE;
        boolean hasB = modelData.getConnectionType(b) != ConnectionType.NONE;
        boolean hasC = modelData.getConnectionType(c) != ConnectionType.NONE;
        boolean hasD = modelData.getConnectionType(d) != ConnectionType.NONE;
        if ((hasA || hasB) != (hasC || hasD)) {
            if (hasA && hasB) {
                return IconStatus.NO_ROTATION;
            }
            if (hasC && hasD) {
                return IconStatus.ROTATE_270;
            }
        }
        return IconStatus.NO_SHOW;
    }

    @Override
    public boolean hasMaterial(@NotNull String name) {
        return this.internal.hasMaterial(this.adjustTextureName(name));
    }

    @Override
    @NotNull
    public Material getMaterial(@NotNull String name) {
        return this.internal.getMaterial(this.adjustTextureName(name));
    }

    public static enum IconStatus {
        NO_ROTATION(0.0f),
        ROTATE_270(270.0f),
        NO_SHOW(0.0f);

        private final float angle;

        private IconStatus(float angle) {
            this.angle = angle * ((float)Math.PI / 180);
        }

        public float getAngle() {
            return this.angle;
        }
    }
}

