/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common.me.cell;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.core.definitions.AEItems;
import com.glodblock.github.appflux.api.IFluxCell;
import com.glodblock.github.appflux.common.me.key.FluxKey;
import com.glodblock.github.appflux.common.me.key.type.EnergyType;
import com.glodblock.github.appflux.common.me.key.type.FluxKeyType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public abstract class FluxCellInventory
implements StorageCell {
    protected static final String DATA = "power";
    protected final IFluxCell cellType;
    protected final ItemStack stack;
    protected final boolean hasVoidUpgrade;
    @Nullable
    protected final ISaveProvider container;
    protected long storedEnergy = 0L;
    protected boolean isPersisted = true;

    public FluxCellInventory(IFluxCell cellType, ItemStack o, @Nullable ISaveProvider container) {
        this.cellType = cellType;
        this.stack = o;
        this.container = container;
        CompoundTag tag = o.m_41783_();
        if (tag != null) {
            this.storedEnergy = tag.m_128454_(DATA);
        }
        this.hasVoidUpgrade = this.getUpgrades().isInstalled((ItemLike)AEItems.VOID_CARD);
    }

    public CellState getStatus() {
        if (this.storedEnergy == 0L) {
            return CellState.EMPTY;
        }
        if (this.storedEnergy == this.getMaxEnergy()) {
            return CellState.FULL;
        }
        return CellState.NOT_EMPTY;
    }

    public IUpgradeInventory getUpgrades() {
        return this.cellType.getUpgrades(this.stack);
    }

    public double getIdleDrain() {
        return this.cellType.getIdleDrain();
    }

    public long getStoredEnergy() {
        return this.storedEnergy;
    }

    public long getMaxEnergy() {
        return this.cellType.getBytes(this.stack) * (long)FluxKeyType.TYPE.getAmountPerByte();
    }

    public long getTotalBytes() {
        return this.cellType.getBytes(this.stack);
    }

    public long getUsedBytes() {
        long amountPerByte = FluxKeyType.TYPE.getAmountPerByte();
        return (this.storedEnergy + amountPerByte - 1L) / amountPerByte;
    }

    protected void saveChanges() {
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (!(what instanceof FluxKey)) {
            return 0L;
        }
        long inserted = Math.min(this.getMaxEnergy() - this.storedEnergy, amount);
        if (mode == Actionable.MODULATE) {
            this.storedEnergy += inserted;
            this.saveChanges();
        }
        return this.hasVoidUpgrade ? amount : inserted;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (!(what instanceof FluxKey)) {
            return 0L;
        }
        long extracted = Math.min(this.storedEnergy, amount);
        if (mode == Actionable.MODULATE) {
            this.storedEnergy -= extracted;
            this.saveChanges();
        }
        return extracted;
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        if (this.storedEnergy <= 0L) {
            this.stack.m_41749_(DATA);
        } else {
            this.stack.m_41784_().m_128356_(DATA, this.storedEnergy);
        }
        this.isPersisted = true;
    }

    public void getAvailableStacks(KeyCounter out) {
        if (this.storedEnergy > 0L) {
            out.add((AEKey)FluxKey.of(this.getEnergyType()), this.storedEnergy);
        }
    }

    protected abstract EnergyType getEnergyType();

    public Component getDescription() {
        return this.stack.m_41786_();
    }
}

